function  [X,y] = plot_slope_resampled(temp_raster,times,bin_wid_all,bin_ratio)

new_trial_max = 1;


bin_vec = bin_ratio * bin_wid_all;
X = (bin_wid_all * bin_ratio)' * 1e-3;

temp_raster_big_trials = cell(length(temp_raster),new_trial_max);
for tim_num=1:length(times)
    bin_start = times(tim_num) - bin_wid_all/2;
    bin_end = times(tim_num) + bin_wid_all/2;
    
    %%%% remove zero isi in a trial
    isi_raster_count = cell2mat(cellfun(@(x) length(x),temp_raster,'UniformOutput',false));
    new_temp_raster = temp_raster(isi_raster_count~=0);
    bin_isi_raster = cellfun(@(x) diff(x(max([1,find(x<bin_start,1,'last')],[],'omitnan'):min([length(x),find(x>bin_end,1,'first')],[],'omitnan' ))),new_temp_raster,'UniformOutput',false);
    spike_bin_time =  cellfun(@(x) x((x>bin_start) & (x<bin_end)),new_temp_raster,'UniformOutput',false);
    
    for tr_num=1:length(bin_isi_raster)
        if(isempty(bin_isi_raster{tr_num}) || isempty(spike_bin_time{tr_num}) || (length(bin_isi_raster{tr_num})<3))
            for new_num=1:new_trial_max
                temp_raster_big_trials{tr_num,new_num} = [temp_raster_big_trials{tr_num,new_num},spike_bin_time{tr_num}];
            end
        else
            for new_num=1:new_trial_max
                outer_isi = bin_isi_raster{tr_num}([1,end]);
                inter_isi = bin_isi_raster{tr_num}(2:end-1);
                is_out = ~isoutlier(bin_isi_raster{tr_num});
                non_outlir_isi = [inter_isi;outer_isi(is_out([1,end]))];
                if(~isempty(non_outlir_isi))
                    start_time  = datasample(spike_bin_time{tr_num}(1) -  non_outlir_isi,1);
                else
                    start_time  = spike_bin_time{tr_num}(1);
                end
                temp_spi = [start_time;start_time + cumsum(datasample(non_outlir_isi,length(non_outlir_isi),'Replace',false))];
                temp_spi = temp_spi((temp_spi>bin_start) & (temp_spi<bin_end));
                spike_time = reshape(temp_spi,1,length(temp_spi));
                temp_raster_big_trials{tr_num,new_num} = [temp_raster_big_trials{tr_num,new_num},spike_time];
            end
        end
    end
end


rand_count = 10;
mean_mat = zeros(rand_count,1);
var_mat = mean_mat;
new_temp_raster = temp_raster_big_trials(:);

fano_temp = zeros(length(times),length(bin_ratio));
mean_temp = fano_temp;
var_temp = mean_temp;
for tim_num =1:length(times)
    time_bin = times(tim_num);
    for bin_widnum = 1:length(bin_vec)
        bin_temp = bin_vec(bin_widnum);
        for rand_time = 1:rand_count
            bin_edge = [time_bin-bin_temp/2,time_bin+bin_temp/2]+(-1 * (bin_wid_all-bin_temp)/2) + rand * (bin_wid_all-bin_temp);
            mat_cell = cellfun(@(x) histcounts(x,bin_edge),new_temp_raster,'UniformOutput',false);
            mat = cell2mat(mat_cell)';
            % calc
            mean_mat(rand_time) = nanmean(mat,2);
            var_mat(rand_time) = nanvar(mat,[],2);
        end
        mean_temp(tim_num,bin_widnum) = nanmean(mean_mat);
        var_temp(tim_num,bin_widnum) = nanmean(var_mat);
        fano_temp(tim_num,bin_widnum) = nanmean(squeeze(var_mat ./ mean_mat));
    end

    %%% regression
    y =  fano_temp(tim_num,:);
    
    
end
